-- Copyright 2007 Omni Development, Inc.  All rights reserved.
-- RCS_ID("$Header: svn+ssh://source.omnigroup.com/Source/svn/Omni/tags/OmniFocus/1.0.1/final-77.1.4/OmniGroup/Applications/Focus/ScriptHandlers/BuiltInClippingHandlers/Safari.applescript 93889 2007-11-02 18:06:50Z bungi $")

on clipping(CurrentApplicationInfo, ClippingTasks)
	-- Grab Safari specific stuff
	tell application "Mailplane 3"
		set MyPageTitle to currentTitle
		set MyURL to currentURL
	end tell
	if MyPageTitle is "" or MyPageTitle is missing value then
		set MyPageTitle to "Mailplane 3"
	end if
	
	using terms from application "OmniFocus"
		repeat with MyTask in ClippingTasks
			tell MyTask
				set MySummary to (summarize note as rich text)
				if MySummary is "" or MySummary is missing value then
					set MySummary to MyPageTitle
				end if
				
				set name to MyPageTitle
				tell note
					-- Build up a prefix, inserting tail to head
					insert return & return at before first character
					
					-- TODO: Bundles need to be able to pass in localized values as part of their settings or some such.
					set MyHeader to MyPageTitle
					insert MyHeader at before first character
					set value of attribute "link" of style of paragraph 1 to MyURL -- We know that there is a newline since we just inserted it!
				end tell
				
			end tell
		end repeat
		return {CurrentApplicationInfo, {}} -- handled all the tasks
	end using terms from
end clipping
